/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.CommitDialog;
import com.aptana.git.ui.internal.actions.Messages;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class CommitHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository theRepo = this.getSelectedRepository();
        if (theRepo == null && this.getSelectedResources() != null && this.getSelectedResources().isEmpty()) {
            this.openError(Messages.CommitAction_NoRepo_Title, Messages.CommitAction_NoRepo_Message);
            return null;
        }
        if (theRepo == null && this.getSelectedResources() != null && this.getSelectedResources().size() != 1) {
            this.openError(Messages.CommitAction_MultipleRepos_Title, Messages.CommitAction_MultipleRepos_Message);
            return null;
        }
        CommitDialog dialog = new CommitDialog(this.getShell(), theRepo);
        dialog.open();
        return null;
    }

    protected boolean calculateEnabled() {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return false;
        }
        return !repo.index().changedFiles().isEmpty() || repo.hasUnresolvedMergeConflicts();
    }
}

